#include <openssl/x509AT.h>

/***************************************************************************

BEGIN_ANYADIDO por mi 03/06/2003

***************************************************************************/

ASN1_CHOICE(X509AT_ATTRIBUTE_SET) = {
	ASN1_SET_OF(X509AT_ATTRIBUTE, value.set, ASN1_ANY),
	ASN1_SIMPLE(X509AT_ATTRIBUTE, value.single, ASN1_ANY)
} ASN1_CHOICE_END_selector(X509AT_ATTRIBUTE, X509AT_ATTRIBUTE_SET, single)

ASN1_SEQUENCE(X509AT_ATTRIBUTE) = {
	ASN1_SIMPLE(X509AT_ATTRIBUTE, object, ASN1_OBJECT),
	/* CHOICE type merged with parent */
	ASN1_EX_COMBINE(0, 0, X509AT_ATTRIBUTE_SET)
} ASN1_SEQUENCE_END(X509AT_ATTRIBUTE)

IMPLEMENT_ASN1_FUNCTIONS(X509AT_ATTRIBUTE)
/*IMPLEMENT_ASN1_DUP_FUNCTION(X509AT_ATTRIBUTE)*/

X509AT_ATTRIBUTE *X509AT_ATTRIBUTE_create(int nid, int atrtype, void *value)
	{
	X509AT_ATTRIBUTE *ret=NULL;
	ASN1_TYPE *val=NULL;

	if ((ret=X509AT_ATTRIBUTE_new()) == NULL)
		return(NULL);
	ret->object=OBJ_nid2obj(nid);
	ret->single=0;
	if ((ret->value.set=sk_ASN1_TYPE_new_null()) == NULL) goto err;
	if ((val=ASN1_TYPE_new()) == NULL) goto err;
	if (!sk_ASN1_TYPE_push(ret->value.set,val)) goto err;

	ASN1_TYPE_set(val,atrtype,value);
	return(ret);
err:
	if (ret != NULL) X509AT_ATTRIBUTE_free(ret);
	if (val != NULL) ASN1_TYPE_free(val);
	return(NULL);
	}

/***************************************************************************

END_ANYADIDO por mi 03/06/2003

***************************************************************************/

ASN1_SEQUENCE(X509AT_VAL) = {
			ASN1_SIMPLE(X509AT_VAL, notBeforeTime, ASN1_GENERALIZEDTIME),
			ASN1_SIMPLE(X509AT_VAL, notAfterTime, ASN1_GENERALIZEDTIME)
		} ASN1_SEQUENCE_END(X509AT_VAL)

IMPLEMENT_ASN1_FUNCTIONS(X509AT_VAL)
/*IMPLEMENT_ASN1_DUP_FUNCTION(X509AT_VAL)*/


ASN1_SEQUENCE(X509AT_ISSUER_SERIAL) = {
			ASN1_SIMPLE(X509AT_ISSUER_SERIAL, issuer, GENERAL_NAMES),
			ASN1_SIMPLE(X509AT_ISSUER_SERIAL, serial, ASN1_INTEGER),
			ASN1_OPT(X509AT_ISSUER_SERIAL, issuerUID, ASN1_BIT_STRING)
		} ASN1_SEQUENCE_END(X509AT_ISSUER_SERIAL)

IMPLEMENT_ASN1_FUNCTIONS(X509AT_ISSUER_SERIAL)
/*IMPLEMENT_ASN1_DUP_FUNCTION(X509AT_ISSUER_SERIAL)*/


ASN1_SEQUENCE(X509AT_OBJECTDIGESTINFO) = {
			ASN1_SIMPLE(X509AT_OBJECTDIGESTINFO, digestedObjectType, ASN1_ENUMERATED),
			ASN1_OPT(X509AT_OBJECTDIGESTINFO, otherObjectTypeID, ASN1_OBJECT),
			ASN1_SIMPLE(X509AT_OBJECTDIGESTINFO, digestAlgorithm, X509_ALGOR),
			ASN1_SIMPLE(X509AT_OBJECTDIGESTINFO, objectDigest, ASN1_BIT_STRING)
		} ASN1_SEQUENCE_END(X509AT_OBJECTDIGESTINFO)

IMPLEMENT_ASN1_FUNCTIONS(X509AT_OBJECTDIGESTINFO)
/*IMPLEMENT_ASN1_DUP_FUNCTION(X509AT_OBJECTDIGESTINFO)*/

/***************************************************************************

BEGIN_MODIFICADO por mi 30/05/2003

ASN1_SEQUENCE(X509AT_HOLDER) = {
			ASN1_IMP_OPT(X509AT_HOLDER, baseCertificateID, X509AT_ISSUER_SERIAL,0),
			ASN1_IMP_OPT(X509AT_HOLDER, entityName, GENERAL_NAMES,1), 	
			ASN1_IMP_OPT(X509AT_HOLDER, objectDigestInfo, X509AT_OBJECTDIGESTINFO,2)
		} ASN1_SEQUENCE_END(X509AT_HOLDER)

***************************************************************************/

ASN1_SEQUENCE(X509AT_HOLDER) = {
			ASN1_IMP_OPT(X509AT_HOLDER, baseCertificateID, X509AT_ISSUER_SERIAL,0),
			ASN1_IMP_SEQUENCE_OF_OPT(X509AT_HOLDER, entityName, GENERAL_NAME,1), 	
			ASN1_IMP_OPT(X509AT_HOLDER, objectDigestInfo, X509AT_OBJECTDIGESTINFO,2)
		} ASN1_SEQUENCE_END(X509AT_HOLDER)


IMPLEMENT_ASN1_FUNCTIONS(X509AT_HOLDER)
/*IMPLEMENT_ASN1_DUP_FUNCTION(X509AT_HOLDER)*/

/***************************************************************************

END_MODIFICADO por mi 30/05/2003

***************************************************************************/

/***************************************************************************

BEGIN_MODIFICADO por mi 29/05/2003

ASN1_SEQUENCE(X509AT_ATTCERTISSUER) = {
			ASN1_OPT(X509AT_ATTCERTISSUER, issuerName, GENERAL_NAMES),
			ASN1_IMP_OPT(X509AT_ATTCERTISSUER, baseCertificateID, X509AT_ISSUER_SERIAL,0),
			ASN1_IMP_OPT(X509AT_ATTCERTISSUER, objectDigestInfo, X509AT_OBJECTDIGESTINFO,1)
		} ASN1_SEQUENCE_END(X509AT_ATTCERTISSUER)


IMPLEMENT_ASN1_FUNCTIONS(X509AT_ATTCERTISSUER)
***************************************************************************/

/***************************************************************************

BEGIN_MODIFICADO por mi 01/07/2003

ASN1_SEQUENCE(X509AT_V2FORM) = {
			ASN1_OPT(X509AT_V2FORM, issuerName, GENERAL_NAMES),
			ASN1_IMP_OPT(X509AT_V2FORM, baseCertificateID, X509AT_ISSUER_SERIAL,0),
			ASN1_IMP_OPT(X509AT_V2FORM, objectDigestInfo, X509AT_OBJECTDIGESTINFO,1)
		} ASN1_SEQUENCE_END(X509AT_V2FORM)

IMPLEMENT_ASN1_FUNCTIONS(X509AT_V2FORM)


ASN1_CHOICE(X509AT_ATTCERTISSUER) = {
	ASN1_SIMPLE(X509AT_ATTCERTISSUER, value.v1Form, GENERAL_NAMES),
	ASN1_IMP(X509AT_ATTCERTISSUER,  value.v2Form, X509AT_V2FORM, 0)
} ASN1_CHOICE_END(X509AT_ATTCERTISSUER)

IMPLEMENT_ASN1_FUNCTIONS(X509AT_ATTCERTISSUER)
***************************************************************************/

ASN1_SEQUENCE(X509AT_V2FORM) = {
			ASN1_SEQUENCE_OF_OPT(X509AT_V2FORM, issuerName, GENERAL_NAME),
			ASN1_IMP_OPT(X509AT_V2FORM, baseCertificateID, X509AT_ISSUER_SERIAL,0),
			ASN1_IMP_OPT(X509AT_V2FORM, objectDigestInfo, X509AT_OBJECTDIGESTINFO,1)
		} ASN1_SEQUENCE_END(X509AT_V2FORM)


IMPLEMENT_ASN1_FUNCTIONS(X509AT_V2FORM)

ASN1_CHOICE(X509AT_ATTCERTISSUER) = {
	ASN1_SEQUENCE_OF(X509AT_ATTCERTISSUER, value.v1Form, GENERAL_NAME),
	ASN1_IMP(X509AT_ATTCERTISSUER,  value.v2Form, X509AT_V2FORM, 0)
} ASN1_CHOICE_END(X509AT_ATTCERTISSUER)

IMPLEMENT_ASN1_FUNCTIONS(X509AT_ATTCERTISSUER)

/***************************************************************************

END_MODIFICADO por mi 01/07/2003

***************************************************************************/


/***************************************************************************

BEGIN_MODIFICADO por mi 03/06/2003


int i2d_X509AT_CINF(X509AT_CINF *a, unsigned char **pp)
	{
	int version=1;	****** Version v2 ******
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len(a->version,i2d_ASN1_INTEGER);
	M_ASN1_I2D_len(a->holder,		i2d_X509AT_HOLDER);
	M_ASN1_I2D_len(a->issuer,		i2d_X509AT_ATTCERTISSUER);
	M_ASN1_I2D_len(a->signature,		i2d_X509_ALGOR);
	M_ASN1_I2D_len(a->serialNumber,		i2d_ASN1_INTEGER);
	M_ASN1_I2D_len(a->attrCertValidityPeriod,		i2d_X509AT_VAL);

	M_ASN1_I2D_len_SEQUENCE_type(X509_ATTRIBUTE,a->attributes, i2d_X509_ATTRIBUTE);
	M_ASN1_I2D_len_IMP_opt(a->issuerUID,	i2d_ASN1_BIT_STRING);
	M_ASN1_I2D_len_IMP_SEQUENCE_opt_type(X509_EXTENSION,a->extensions,
					     i2d_X509_EXTENSION,
					     V_ASN1_SEQUENCE);

	M_ASN1_I2D_seq_total();

	M_ASN1_I2D_put(a->version,i2d_ASN1_INTEGER);
	M_ASN1_I2D_put(a->holder,		i2d_X509AT_HOLDER);
	M_ASN1_I2D_put(a->issuer,		i2d_X509AT_ATTCERTISSUER);
	M_ASN1_I2D_put(a->signature,		i2d_X509_ALGOR);
	M_ASN1_I2D_put(a->serialNumber,		i2d_ASN1_INTEGER);
	M_ASN1_I2D_put(a->attrCertValidityPeriod,		i2d_X509AT_VAL);

	M_ASN1_I2D_put_SEQUENCE_type(X509_ATTRIBUTE,a->attributes, i2d_X509_ATTRIBUTE);


	M_ASN1_I2D_put_IMP_opt(a->issuerUID,i2d_ASN1_BIT_STRING,0);

************************************************************************************
	if (a->issuerUID != NULL) 
		{ 
		M_ASN1_I2D_put(a->issuerUID,i2d_ASN1_BIT_STRING);
		}

************************************************************************************

	M_ASN1_I2D_put_IMP_SEQUENCE_opt_type(X509_EXTENSION,a->extensions,i2d_X509_EXTENSION,V_ASN1_SEQUENCE);

	M_ASN1_I2D_finish();
	}

X509AT_CINF *d2i_X509AT_CINF(X509AT_CINF **a, unsigned char **pp, long length)
	{
	M_ASN1_D2I_vars(a,X509AT_CINF *,X509AT_CINF_new);

	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get(ret->version,d2i_ASN1_INTEGER);
	M_ASN1_D2I_get(ret->holder,d2i_X509AT_HOLDER);
	M_ASN1_D2I_get(ret->issuer,d2i_X509AT_ATTCERTISSUER);
	M_ASN1_D2I_get(ret->signature,d2i_X509_ALGOR);
	M_ASN1_D2I_get(ret->serialNumber,d2i_ASN1_INTEGER);
	M_ASN1_D2I_get(ret->attrCertValidityPeriod,d2i_X509AT_VAL);
	
	if (ret->attributes != NULL)
		while (sk_X509_ATTRIBUTE_num(ret->attributes))
			X509_ATTRIBUTE_free(
			      sk_X509_ATTRIBUTE_pop(ret->attributes));

	M_ASN1_D2I_get_set_type(X509_ATTRIBUTE,ret->attributes,
						d2i_X509_ATTRIBUTE,
						X509_ATTRIBUTE_free);


	if (ret->issuerUID != NULL)
		{
		M_ASN1_BIT_STRING_free(ret->issuerUID);
		ret->issuerUID=NULL;
		}

	M_ASN1_D2I_get_opt(ret->issuerUID,d2i_ASN1_BIT_STRING,
			V_ASN1_BIT_STRING);
		

	if (ret->extensions != NULL)
		while (sk_X509_EXTENSION_num(ret->extensions))
			X509_EXTENSION_free(
			      sk_X509_EXTENSION_pop(ret->extensions));
	M_ASN1_D2I_get_IMP_set_opt_type(X509_EXTENSION,ret->extensions,
					d2i_X509_EXTENSION,
					X509_EXTENSION_free,0);

	M_ASN1_D2I_Finish(a,X509AT_CINF_free,ASN1_F_D2I_X509AT_CINF);
	}

X509AT_CINF *X509AT_CINF_new(void)
	{
	X509AT_CINF *ret=NULL;
	ASN1_CTX c;

	M_ASN1_New_Malloc(ret,X509AT_CINF);
	M_ASN1_New(ret->version,M_ASN1_INTEGER_new);
	M_ASN1_New(ret->holder,X509AT_HOLDER_new);
	M_ASN1_New(ret->issuer,X509AT_ATTCERTISSUER_new);
	M_ASN1_New(ret->signature,X509_ALGOR_new);
	M_ASN1_New(ret->serialNumber,M_ASN1_INTEGER_new);
	M_ASN1_New(ret->attrCertValidityPeriod,X509AT_VAL_new);
	M_ASN1_New(ret->attributes,sk_new_null);
	ret->issuerUID=NULL;
	ret->extensions=NULL;
	return(ret);
	M_ASN1_New_Error(ASN1_F_X509_CINF_NEW);
	}

void X509AT_CINF_free(X509AT_CINF *a)
	{
	if (a == NULL) return;
	M_ASN1_INTEGER_free(a->version);
	X509AT_HOLDER_free(a->holder);
	X509AT_ATTCERTISSUER_free(a->issuer);
	X509_ALGOR_free(a->signature);
	M_ASN1_INTEGER_free(a->serialNumber);
	X509AT_VAL_free(a->attrCertValidityPeriod);
	sk_X509_ATTRIBUTE_pop_free(a->attributes,X509_ATTRIBUTE_free);
	M_ASN1_BIT_STRING_free(a->issuerUID);
	sk_X509_EXTENSION_pop_free(a->extensions,X509_EXTENSION_free);
	OPENSSL_free(a);
	}

***************************************************************************/

ASN1_SEQUENCE(X509AT_CINF) = {
			ASN1_SIMPLE(X509AT_CINF, version, ASN1_INTEGER),
			ASN1_SIMPLE(X509AT_CINF, holder, X509AT_HOLDER),
			ASN1_SIMPLE(X509AT_CINF, issuer, X509AT_ATTCERTISSUER),
			ASN1_SIMPLE(X509AT_CINF, signature, X509_ALGOR),
			ASN1_SIMPLE(X509AT_CINF, serialNumber, ASN1_INTEGER),
			ASN1_SIMPLE(X509AT_CINF, attrCertValidityPeriod, X509AT_VAL),
			ASN1_SEQUENCE_OF(X509AT_CINF, attributes, X509AT_ATTRIBUTE),
			ASN1_OPT(X509AT_CINF, issuerUID, ASN1_BIT_STRING),
			ASN1_SEQUENCE_OF_OPT(X509AT_CINF, extensions, X509_EXTENSION)
		} ASN1_SEQUENCE_END(X509AT_CINF)


IMPLEMENT_ASN1_FUNCTIONS(X509AT_CINF)

/***************************************************************************

END_MODIFICADO por mi 03/06/2003

***************************************************************************/

/***************************************************************************

BEGIN_ANYADIDO por mi 18/07/2003

***************************************************************************/

ASN1_SEQUENCE(X509AT) = {
	ASN1_SIMPLE(X509AT, cert_info_at, X509AT_CINF),
	ASN1_SIMPLE(X509AT, sig_alg, X509_ALGOR),
	ASN1_SIMPLE(X509AT, signature, ASN1_BIT_STRING)
} ASN1_SEQUENCE_END(X509AT)

IMPLEMENT_ASN1_FUNCTIONS(X509AT)

/***************************************************************************

END_ANYADIDO por mi 18/07/2003

***************************************************************************/
